/******************************************************************************
 * File     :  pcf8574a.c
 * Purpose  :  I2C PCF8574A I/O
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  I2C_SDA     PIN_C4   // I2C SDA
#define  I2C_SCL     PIN_C3   // I2C SCL
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  I2C_SDA     PIN_A1   // I2C SDA
#define  I2C_SCL     PIC_A0   // I2C SCL
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)
#use I2C(master,sda=I2C_SDA,scl=I2C_SCL)


/***********************************************************************
 *	Constants
 ***********************************************************************/
#define PCF8574A_ID  0x70  // 01110000, PCF8574A:000 Slave Address (bit1-bit3)


/***********************************************************************
 * FUNCTION:     PCF8574A_Write
 * DESCRIPTION:  PCF8574A Write
 * PARAMETERS:   Data
 * RETURNED:     nothing
 ***********************************************************************/
void PCF8574A_Write(int dat) {

   i2c_start();               // Send I2C Start Transfer
   i2c_write(PCF8574A_ID);    // Send identifier I2C address - Write
   i2c_write(dat); 		      // Send data
   i2c_stop();                // Send I2C Stop Transfer
}


/***********************************************************************
 * FUNCTION:     PCF8574A_Read
 * DESCRIPTION:  PCF8574A Read
 * PARAMETERS:   nothing
 * RETURNED:     char
 ***********************************************************************/
int PCF8574A_Read(void) {

   int inData;

   i2c_start();             	// Send I2C Start Transfer
   i2c_write(PCF8574A_ID+1);  // Send identifier I2C address - Read
   inData = i2c_read(0);      // Read data , Not ACK
   i2c_stop();                // Send I2C Stop Transfer

   printf("\r\n\nI2C Read Data %x",inData);
   return(inData);
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int OutData, InData;

	PCF8574A_Write(0x00);

   while(TRUE) {

      InData = PCF8574A_Read();     // Read data

      InData &= 0xF0;               // And Data
      OutData = swap(InData);       // Swap bit

      PCF8574A_Write(OutData);      // Out data
   }
}
